
$(function () {
	$.validator.setDefaults({
		submitHandler: function (form) {
			form.submit();
		}
	});

	$('#js-template-form').validate({
		rules: {
			name: {
				required: true
			},

			type: {
				required: true
			},
			body: {
				required: true
			}
		},
		messages: {
			name: "Please enter template name",
			type: "Please select template type",
			body: "This field is required",

		},
		errorElement: 'span',
		errorPlacement: function (error, element) {
			error.addClass('invalid-feedback');
			element.closest('.form-group').append(error);
		},
		highlight: function (element, errorClass, validClass) {
			$(element).addClass('is-invalid');
		},
		unhighlight: function (element, errorClass, validClass) {
			$(element).removeClass('is-invalid');
		}
	});
});
